*** Table 3:  Changes in Legislators' Ideology


cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 

*** OPEN MAIN CD DTA 
use  "$data/main_CD.dta", clear


foreach t in 40 50 {
gen y_`t'=0
replace y_`t'=1 if year==19`t'

gen fr_b40n_p78_y`t'=fr_b40n_p78*y_`t'
gen dem_40_y`t'=dem_40*y_`t'
gen wp_civilrightsagn_78_y`t'=wp_civilrightsagn_78*y_`t'
gen wp_civilrightscons_78_y`t'=wp_civilrightscons_78*y_`t'
}

.

xtset cds year, delta(10)
egen stateyear=group(statefip year)
global controls  fr_b40n_p78_y* dem_40_y*

*********************************************************************

cd  "$output"

// Panel A - OLS 

* Agnostic 
reg D_civilrightsagn D_fr_bl_p78  $controls  i.stateyear wp_civilrightsagn_78_y* [aw=pop_cd78], cl(cds)  
outreg2 using Table3_A.xls, excel nocon replace ///
keep (D_fr_bl_p78)  dec(3)   addtext(spec,  "78-82;82-88")


foreach j in agn  { 

foreach i in 40 50 {
	
reg D_civilrights`j' D_fr_bl_p78  $controls   i.stateyear wp_civilrights`j'_78_y* [aw=pop_cd78]   if year==19`i', cl(cds)
outreg2 using Table3_A.xls, excel nocon append ///
keep (D_fr_bl_p78)  dec(3)   addtext(spec,`i')

}

}


* Constrained 

reg D_civilrightscons D_fr_bl_p78 $controls i.stateyear wp_civilrightscons_78_y* [aw=pop_cd78], cl(cds)  
outreg2 using Table3_A.xls, excel nocon append ///
keep (D_fr_bl_p78)  dec(3)   addtext(spec, "78-82;82-88")


foreach j in cons  { 

foreach i in 40 50 {
	
reg D_civilrights`j' D_fr_bl_p78  $controls  i.stateyear wp_civilrights`j'_78_y* [aw=pop_cd78]   if year==19`i', cl(cds)
outreg2 using Table3_A.xls, excel nocon append ///
keep (D_fr_bl_p78)  dec(3)   addtext(spec,`i')

}

}




// Panel B - 2SLS 

* Agnostic 
ivreg2 D_civilrightsagn  (D_fr_bl_p78=Z_p78)  $controls  wp_civilrightsagn_78_y* i.stateyear  [aw=pop_cd78] , cl(cds)  ffirst savefirst
local F=e(widstat)
outreg2 using Table3_B.xls, excel nocon replace ///
keep (D_fr_bl_p78)  dec(3) addstat( "F-stat", `F')   addtext(spec,  "78-82;82-88")

est restore _ivreg2_D_fr_bl_p78
outreg2 using Table3_C.xls, excel nocon replace ///
keep (Z_p78)  dec(3)



foreach j in agn  { 

foreach i in 40 50 {
ivreg2 D_civilrights`j'  (D_fr_bl_p78=Z_p78)  $controls wp_civilrights`j'_78_y* i.stateyear  [aw=pop_cd78] if year==19`i', cl(cds)  ffirst savefirst
local F=e(widstat)
outreg2 using Table3_B.xls, excel nocon append ///
keep (D_fr_bl_p78)  dec(3) addstat( "F-stat", `F')  addtext(spec,`i')

est restore _ivreg2_D_fr_bl_p78
outreg2 using Table3_C.xls, excel nocon append ///
keep (Z_p78)  dec(3)

}

}


* Constrained 
ivreg2 D_civilrightscons  (D_fr_bl_p78=Z_p78)  $controls   wp_civilrightscons_78_y*  i.stateyear  [aw=pop_cd78] , cl(cds)  ffirst savefirst
local F=e(widstat)
outreg2 using Table3_B.xls, excel nocon append ///
keep (D_fr_bl_p78)  dec(3) addstat( "F-stat", `F')   addtext(spec,  "78-82;82-88")

est restore _ivreg2_D_fr_bl_p78
outreg2 using Table3_C.xls, excel nocon append ///
keep (Z_p78)  dec(3)


foreach j in cons  { 
	
foreach i in 40 50 {
	
ivreg2 D_civilrights`j'  (D_fr_bl_p78=Z_p78)  fr_b40n_p78_y* dem_40_y* wp_civilrights`j'_78_y* i.stateyear  [aw=pop_cd78] if year==19`i', cl(cds)  ffirst savefirst
local F=e(widstat)
outreg2 using Table3_B.xls, excel nocon append ///
keep (D_fr_bl_p78)  dec(3) addstat( "F-stat", `F')  addtext(spec,`i')

est restore _ivreg2_D_fr_bl_p78
outreg2 using Table3_C.xls, excel nocon append ///
keep (Z_p78)  dec(3)

}

}

